--<ScriptOptions statementTerminator=";"/>

CREATE TABLE CPH.BURIAL_PERSON_COMPLETE (
    ID INTEGER NOT NULL,
    NUMBER INTEGER DEFAULT NULL,
    FIRSTNAMES CHAR(100) DEFAULT 'NULL',
    LASTNAME CHAR(100) DEFAULT 'NULL',
    BIRTHNAME CHAR(100) DEFAULT 'NULL',
    AGEYEARS INTEGER DEFAULT NULL,
    AGEMONTH DECIMAL(4 , 2) DEFAULT NULL,
    AGEWEEKS DECIMAL(4 , 2) DEFAULT NULL,
    AGEDAYS DECIMAL(4 , 2) DEFAULT NULL,
    AGEHOURS INTEGER DEFAULT NULL,
    DATEOFBIRTH DATE DEFAULT NULL,
    DATEOFDEATH DATE DEFAULT NULL,
    YEAROFBIRTH INTEGER DEFAULT NULL,
    DEATHPLACE VARCHAR(4096) DEFAULT 'NULL',
    CIVILSTATUS CHAR(25) DEFAULT 'NULL',
    ADRESSOUTSIDECPH VARCHAR(255) DEFAULT 'NULL',
    SEX CHAR(10) DEFAULT 'NULL',
    COMMENT VARCHAR(16384),
    CEMETARY CHAR(100) DEFAULT 'NULL',
    CHAPEL CHAR(100) DEFAULT 'NULL',
    PARISH CHAR(100) DEFAULT 'NULL',
    STREET CHAR(75) DEFAULT 'NULL',
    HOOD CHAR(25) DEFAULT 'NULL',
    STREET_NUMBER INTEGER DEFAULT NULL,
    LETTER CHAR(1) DEFAULT 'NULL',
    FLOOR CHAR(15) DEFAULT 'NULL',
    INSTITUTION CHAR(100) DEFAULT 'NULL',
    INSTITUTION_STREET CHAR(75) DEFAULT 'NULL',
    INSTITUTION_HOOD CHAR(25) DEFAULT 'NULL',
    INSTITUTION_STREET_NUMBER INTEGER DEFAULT NULL,
    OCCUPATIONS VARCHAR(4096) DEFAULT 'NULL',
    OCCUPATION_RELATION_TYPES VARCHAR(4096) DEFAULT 'NULL',
    DEATHCAUSES VARCHAR(4096) DEFAULT 'NULL',
    DEATHCAUSES_DANISH VARCHAR(4096) DEFAULT 'NULL',
    PHONNAME CHAR(64)
  );


CREATE TABLE CPH.POLICE_POSITION (
    ID INTEGER NOT NULL,
    PERSON_ID INTEGER NOT NULL,
    POSITION_DANISH VARCHAR(100) DEFAULT 'NULL',
    POSITION_ENGLISH VARCHAR(100) DEFAULT 'NULL',
    ISCO_MAJOR_GROUP CHAR(5) DEFAULT 'NULL',
    ISCO_SUBMAJOR_GROUP CHAR(5) DEFAULT 'NULL',
    ISCO_MINOR_GROUP CHAR(5) DEFAULT 'NULL',
    ISCO_UNIT CHAR(5) DEFAULT 'NULL'
  );

CREATE TABLE CPH.POLICE_PERSON (
    ID INTEGER NOT NULL,
    FIRSTNAMES CHAR(80) DEFAULT 'NULL',
    LASTNAME CHAR(50) DEFAULT 'NULL',
    MAIDENNAME CHAR(50) DEFAULT 'NULL',
    MARRIED BOOLEAN DEFAULT NULL,
    TYPE CHAR(6) DEFAULT 'NULL',
    GENDER INTEGER DEFAULT NULL,
    BIRTHPLACE CHAR(100) DEFAULT 'NULL',
    BIRTHDAY INTEGER DEFAULT NULL,
    BIRTHMONTH INTEGER DEFAULT NULL,
    BIRTHYEAR INTEGER DEFAULT NULL,
    DEATHDAY INTEGER DEFAULT NULL,
    DEATHMONTH INTEGER DEFAULT NULL,
    DEATHYEAR INTEGER DEFAULT NULL,
    PHONNAME CHAR(64) DEFAULT 'NULL'
  );

CREATE TABLE CPH.POLICE_ADDRESS (
    ID INTEGER NOT NULL,
    PERSON_ID INTEGER NOT NULL,
    STREET VARCHAR(65) DEFAULT 'NULL',
    NUMBER VARCHAR(10) DEFAULT 'NULL',
    LETTER VARCHAR(3) DEFAULT 'NULL',
    FLOOR VARCHAR(10) DEFAULT 'NULL',
    SIDE VARCHAR(3) DEFAULT 'NULL',
    PLACE VARCHAR(90) DEFAULT 'NULL',
    HOST VARCHAR(255) DEFAULT 'NULL',
    LATITUDE DECIMAL(18 , 12) DEFAULT NULL,
    LONGITUDE DECIMAL(18 , 12) DEFAULT NULL,
    DAY INTEGER DEFAULT NULL,
    MONTH INTEGER DEFAULT NULL,
    XYEAR INTEGER DEFAULT NULL,
    FULL_ADDRESS VARCHAR(512) DEFAULT 'NULL'
  );

CREATE UNIQUE INDEX CPH.SQL230130210151780
  ON CPH.POLICE_ADDRESS (ID ASC);

CREATE UNIQUE INDEX CPH.SQL230130190752240
  ON CPH.BURIAL_PERSON_COMPLETE (ID ASC);

CREATE UNIQUE INDEX CPH.SQL230129182253090	
  ON CPH.POLICE_POSITION (ID ASC);

CREATE INDEX CPH.SQL230131235849940
  ON CPH.POLICE_POSITION (PERSON_ID ASC);

CREATE INDEX CPH.SQL230131235918140
  ON CPH.POLICE_ADDRESS (PERSON_ID ASC);

CREATE UNIQUE INDEX CPH.SQL230129182252820
  ON CPH.POLICE_PERSON (ID ASC);

CREATE UNIQUE INDEX CPH.SQL230130192800720
  ON CPH.BURIAL_PERSON_COMPLETE (ID ASC);

ALTER TABLE CPH.POLICE_ADDRESS
  ADD CONSTRAINT SQL230129182252700 PRIMARY KEY (ID);

ALTER TABLE CPH.BURIAL_PERSON_COMPLETE
  ADD CONSTRAINT SQL230129182252320 PRIMARY KEY (ID);

ALTER TABLE CPH.POLICE_POSITION
  ADD CONSTRAINT SQL230129182253090 PRIMARY KEY (ID);

ALTER TABLE CPH.POLICE_POSITION
  ADD CONSTRAINT POLICE_P_POLICE_FK
    FOREIGN KEY (PERSON_ID)
    	REFERENCES CPH.POLICE_PERSON (ID)
    	ON DELETE CASCADE;

CREATE INDEX CPH.BURIAL_PHON_IX ON CPH.BURIAL_PERSON_COMPLETE (PHONNAME ASC);
    	
CREATE INDEX CPH.POLICE_PHON_IX ON CPH.POLICE_PERSON (PHONNAME ASC);