--<ScriptOptions statementTerminator=;/>

CREATE TABLE VEJBY.EVENT (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY,
    TYPE CHAR(12),
    SUBTYPE VARCHAR(32),
    DATE DATE,
    INDIVIDUAL CHAR(12),
    FAMILY CHAR(12),
    PLACE VARCHAR(256),
    NOTE VARCHAR(16000),
    SOURCEDETAIL VARCHAR(16000)
  );

CREATE TABLE VEJBY.INDIVIDUAL (
    ID CHAR(12) NOT NULL,
    GIVENNAME CHAR(64),
    SURNAME CHAR(64),
    SEX CHAR(1),
    FAMC CHAR(12),
    PHONNAME CHAR(64),
    BIRTHDATE DATE,
    BIRTHPLACE VARCHAR(256),
    DEATHDATE DATE,
    DEATHPLACE VARCHAR(256),
    PARENTS VARCHAR(256)
  );

CREATE TABLE VEJBY.PARENTS (
   INDIVIDUALKEY CHAR(12) NOT NULL,
   BIRTHYEAR INT,
   NAME VARCHAR(256),
   PARENTS VARCHAR(256),
   FATHERPHONETIC CHAR(64),
   MOTHERPHONETIC CHAR(64),
   PLACE VARCHAR(256)
);
  
CREATE TABLE VEJBY.FAMILY
(
   ID char(12) PRIMARY KEY NOT NULL,
   HUSBAND char(12) DEFAULT ' ',
   WIFE char(12)
)
;
ALTER TABLE VEJBY.FAMILY
ADD CONSTRAINT FAMIL_INDIVIDUA_F2
FOREIGN KEY (WIFE)
REFERENCES VEJBY.INDIVIDUAL(ID) ON DELETE CASCADE
;
ALTER TABLE VEJBY.FAMILY
ADD CONSTRAINT FAMIL_INDIVIDUA_F1
FOREIGN KEY (HUSBAND)
REFERENCES VEJBY.INDIVIDUAL(ID) ON DELETE CASCADE
;
CREATE INDEX SQL230405164611660 ON VEJBY.FAMILY(WIFE)
;
CREATE INDEX SQL230405164611430 ON VEJBY.FAMILY(HUSBAND)
;
CREATE INDEX SQL230124103428540 ON VEJBY.FAMILY(WIFE)
;
CREATE INDEX SQL230124103429560 ON VEJBY.FAMILY(HUSBAND)
;
  

CREATE INDEX VEJBY.EVENT_TYPE
  ON VEJBY.EVENT (TYPE ASC);
  
CREATE INDEX VEJBY.EVENT_SUBTYPE
  ON VEJBY.EVENT (SUBTYPE ASC);
  
CREATE INDEX VEJBY.IND_PHONNAME
  ON VEJBY.INDIVIDUAL (PHONNAME ASC);
  
CREATE INDEX VEJBY.SQL230124103427890
  ON VEJBY.INDIVIDUAL (FAMC ASC);

CREATE UNIQUE INDEX VEJBY.SQL230124103427450
  ON VEJBY.EVENT (ID ASC);

CREATE UNIQUE INDEX VEJBY.SQL230124103426740
  ON VEJBY.INDIVIDUAL (ID ASC);

CREATE UNIQUE INDEX VEJBY.CENSUS_UI
  ON VEJBY.CENSUS (KIPNR ASC, LOEBENR ASC);

CREATE INDEX VEJBY.SQL230124103428330
  ON VEJBY.EVENT (INDIVIDUAL ASC);


ALTER TABLE VEJBY.EVENT
  ADD CONSTRAINT Event_PK PRIMARY KEY (ID);

ALTER TABLE VEJBY.INDIVIDUAL
  ADD CONSTRAINT Individual_PK PRIMARY KEY (ID);


ALTER TABLE VEJBY.INDIVIDUAL
  ADD CONSTRAINT INDIVIDUA_FAMIL_FK
    FOREIGN KEY (FAMC)
            	REFERENCES VEJBY.FAMILY (ID)
            	ON DELETE CASCADE;

ALTER TABLE VEJBY.EVENT
  ADD CONSTRAINT EVEN_INDIVIDUA_FK
    FOREIGN KEY (INDIVIDUAL)
            	REFERENCES VEJBY.INDIVIDUAL (ID)
            	ON DELETE CASCADE;