CREATE TABLE LAEGD.LAEGD
(
   AMT CHAR(32) NOT NULL,
   AAR INT NOT NULL,
   LITRA CHAR(1) NOT NULL,
   RULLETYPE CHAR(32),
   LAEGDNR INT NOT NULL,
   SOGN CHAR(32),
   LAEGDID INT PRIMARY KEY NOT NULL GENERATED ALWAYS AS IDENTITY,
   NEXTLAEGDID INT,
   PREVLAEGDID INT
)
;

CREATE UNIQUE INDEX LAEGD.LAEGDIX ON LAEGD.LAEGD
(
   AMT ASC,
   AAR ASC,
   LITRA ASC,
   RULLETYPE ASC
)
;

CREATE TABLE LAEGD.RULLE
(
   LAEGDID INT NOT NULL,
   LOEBENR INT NOT NULL,
   PREVLAEGDID INT,
   PREVLOEBENR INT,
   FADER CHAR(32),
   SOEN CHAR(32),
   FOEDESTED CHAR(32),
   ALDER INT,
   STOERRELSEITOMMER DECIMAL(5,2),
   OPHOLD CHAR(32),
   ANMAERKNINGER CHAR(64),
   FOEDT DATE,
   GEDCOMID CHAR(32),
   NAVN CHAR(64),
   FADERFON CHAR(32),
   SOENFON CHAR(32)
)
;

ALTER TABLE "LAEGD"."RULLE"
ADD CONSTRAINT LAEGD_FK
FOREIGN KEY (LAEGDID)
REFERENCES "LAEGD"."LAEGD"(LAEGDID)
;

CREATE INDEX LAEGDID_IX ON "LAEGD"."RULLE"(LAEGDID)
;

CREATE UNIQUE INDEX LAEGD.RULLEIX ON LAEGD.RULLE
(
   LAEGDID ASC,
   LOEBENR ASC
)
;