/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.census;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.myerichsen.vejby.census.Household;
import net.myerichsen.vejby.gedcom.Family;

public class Census {
    private static final Logger LOGGER = Logger.getLogger("global");
    private static Census single_instance = null;
    private int year;
    private List<String> headers;
    private List<List<String>> persons;
    private List<Household> households;

    public static Census getInstance(int year) {
        if (single_instance == null) {
            single_instance = new Census(year);
        }
        return single_instance;
    }

    private Census(int year) {
        this.year = year;
        this.persons = new ArrayList<List<String>>();
    }

    public String createHouseholds(int householdFieldNumber) {
        this.setHouseholds(new ArrayList<Household>());
        Household currentHousehold = null;
        String currentHouseholdNumber = "";
        String newHouseholdNumber = "";
        String currentSourceLocation = "";
        String newSourceLocation = "";
        int id = 0;
        for (List<String> currentRow : this.persons) {
            newHouseholdNumber = currentRow.get(householdFieldNumber);
            LOGGER.log(Level.FINE, "Household: " + newHouseholdNumber + ", was: " + currentHouseholdNumber);
            if (!currentHouseholdNumber.equals(newHouseholdNumber) || !currentSourceLocation.equals(newSourceLocation)) {
                currentHousehold = new Household(id++);
                this.getHouseholds().add(currentHousehold);
                currentHouseholdNumber = newHouseholdNumber;
            }
            currentHousehold.getRows().add(currentRow);
        }
        for (Household household : this.households) {
            household.createCensusEvent(this.year);
        }
        return String.valueOf(this.getHouseholds().size()) + " husholdninger udskilt";
    }

    public List<Family> getFamilies() {
        ArrayList<Family> lf = new ArrayList<Family>();
        for (Household household : this.households) {
            List<Family> families = household.getFamilies();
            int j = 0;
            while (j < families.size()) {
                lf.add(families.get(j));
                ++j;
            }
        }
        return lf;
    }

    public Family getFamily(int householdId, int familyId) {
        for (Household household : this.households) {
            if (household.getId() != householdId) continue;
            List<Family> families = household.getFamilies();
            for (Family family : families) {
                if (family.getFamilyId() != familyId) continue;
                return family;
            }
        }
        return null;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public Household getHousehold(int id) {
        for (Household household : this.households) {
            if (household.getId() != id) continue;
            return household;
        }
        return null;
    }

    public List<Household> getHouseholds() {
        return this.households;
    }

    public List<List<String>> getPersons() {
        return this.persons;
    }

    public int getYear() {
        return this.year;
    }

    public String readKipfile(File kipFile) {
        try {
            FileInputStream fis = new FileInputStream(kipFile);
            Scanner sc = new Scanner(fis);
            String headerLine = sc.nextLine();
            this.headers = new LinkedList<String>(Arrays.asList(headerLine.split(";")));
            while (sc.hasNextLine()) {
                LinkedList<String> fields = new LinkedList<String>(Arrays.asList(sc.nextLine().split(";")));
                this.persons.add(fields);
            }
            sc.close();
            fis.close();
            return "Filen " + kipFile + " er indl\u00e6st";
        }
        catch (FileNotFoundException e) {
            return "Filen " + kipFile + " kunne ikke findes";
        }
        catch (IOException e) {
            return "Filen " + kipFile + " kunne ikke l\u00e6ses";
        }
    }

    public String removeEmptyColumns() {
        ArrayList<Integer> emptyColumns = new ArrayList<Integer>();
        int col = 0;
        while (col < this.headers.size()) {
            boolean found = false;
            try {
                for (List<String> person : this.persons) {
                    if (person.get(col).isEmpty()) continue;
                    found = true;
                }
            }
            catch (Exception e) {
                found = false;
            }
            if (!found) {
                emptyColumns.add(col);
            }
            ++col;
        }
        int i = emptyColumns.size() - 1;
        while (i >= 0) {
            int j = (Integer)emptyColumns.get(i);
            LOGGER.log(Level.FINE, "Col " + j + " is empty");
            this.headers.remove(j);
            for (List<String> ls : this.persons) {
                try {
                    ls.remove(j);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            --i;
        }
        return String.valueOf(emptyColumns.size()) + " tomme kolonner blev fjernet";
    }

    public void setHeaders(List<String> headers) {
        this.headers = headers;
    }

    public void setHouseholds(List<Household> households) {
        this.households = households;
    }

    public void setPersons(List<List<String>> persons) {
        this.persons = persons;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String string : this.headers) {
            sb.append(String.valueOf(string) + ";");
        }
        sb.append("\n");
        for (List list : this.persons) {
            for (String string : list) {
                sb.append(String.valueOf(string) + ";");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

