/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.census;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.myerichsen.vejby.gedcom.CensusEvent;
import net.myerichsen.vejby.gedcom.Family;
import net.myerichsen.vejby.gedcom.Individual;
import net.myerichsen.vejby.util.Mapping;

public class Household {
    private static final Logger LOGGER = Logger.getLogger("global");
    private List<List<String>> rows = new ArrayList<List<String>>();
    private List<Family> families = new ArrayList<Family>();
    private List<Individual> singles;
    private List<Individual> persons;
    private int id;
    private CensusEvent censusEvent;
    private int[] mappingKeys;
    private int iYear;

    public Household(int id) {
        this.setPersons(new ArrayList<Individual>());
        this.id = id;
        this.mappingKeys = Mapping.getInstance().getMappingKeys();
    }

    public void createCensusEvent(int year) {
        this.censusEvent = new CensusEvent(year, this.rows.get(0).get(this.mappingKeys[2]), this);
    }

    public String createFamilies(int sexMappingKey) {
        boolean first = true;
        Family family0 = new Family(this.id, 0);
        Family family1 = new Family(this.id, 1);
        for (List<String> row : this.rows) {
            Individual individual = this.createIndividual(row);
            individual.setCensusEvent(this.censusEvent);
            if (first) {
                if (sexMappingKey == -1) {
                    if (individual.getFamilyRole1().equals("")) {
                        individual.setFamilyRole1("Fader");
                        individual.setSex("M");
                        family1.setFather(individual);
                    }
                } else if (individual.getSex().startsWith("M")) {
                    if (individual.getFamilyRole1().equals("")) {
                        individual.setFamilyRole1("Fader");
                    }
                    family1.setFather(individual);
                } else {
                    if (individual.getFamilyRole1().equals("")) {
                        individual.setFamilyRole1("Moder");
                    }
                    family1.setMother(individual);
                }
                first = false;
            } else if (individual.getFamilyRole1().equals("Fader")) {
                family1.setFather(individual);
            } else if (individual.getFamilyRole1().equals("Moder")) {
                family1.setMother(individual);
            } else if (individual.getFamilyRole1().equals("Barn")) {
                family1.getChildren().add(individual);
            } else if (individual.getFamilyRole1().equals("")) {
                family0.getSingles().add(individual);
            }
            this.getPersons().add(individual);
            LOGGER.log(Level.FINE, "Individual added to households.persons: " + individual.getId() + ", " + individual);
        }
        this.families.clear();
        this.families.add(family0);
        this.families.add(family1);
        return "Familie udskilt";
    }

    public Individual createIndividual(List<String> row) {
        Individual individual = new Individual(Integer.parseInt(row.get(this.mappingKeys[1])));
        individual.setName(row.get(this.mappingKeys[4]));
        if (this.mappingKeys[5] != 0) {
            individual.setSex(row.get(this.mappingKeys[5]));
        }
        if (this.mappingKeys[6] != 0) {
            String bd = row.get(this.mappingKeys[6]);
            if (bd.matches("[0-9]{8}")) {
                SimpleDateFormat inputFormat = new SimpleDateFormat("yyyyMMdd");
                SimpleDateFormat outputFormat = new SimpleDateFormat("dd MMM yyyy");
                try {
                    Date date = inputFormat.parse(bd);
                    bd = outputFormat.format(date);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                LOGGER.log(Level.FINE, "Birth date: " + bd);
            }
            individual.setBirthDate(bd);
        } else if (this.mappingKeys[7] != 0) {
            try {
                String sYear = row.get(this.mappingKeys[12]);
                this.iYear = Integer.parseInt(sYear.replaceAll("[^0-9]", ""));
                int birthDate = this.iYear - Integer.parseInt(row.get(this.mappingKeys[7]));
                individual.setBirthDate("Abt. " + birthDate);
            }
            catch (NumberFormatException e) {
                individual.setBirthDate(String.valueOf(row.get(this.mappingKeys[7])) + "??");
            }
        }
        individual.setMaritalStatus(row.get(this.mappingKeys[8]));
        String trade = row.get(this.mappingKeys[9]);
        individual.setTrade(trade);
        int positionKey = this.mappingKeys[10];
        if (positionKey > 0) {
            individual.setPosition(row.get(positionKey));
            individual.setFamilyRole1(this.getFamilyRole(row.get(positionKey)));
        } else {
            individual.setFamilyRole1(this.getFamilyRole(trade));
        }
        if (this.mappingKeys[11] != 0) {
            individual.setBirthPlace(row.get(this.mappingKeys[11]));
        }
        return individual;
    }

    public List<Family> getFamilies() {
        return this.families;
    }

    private String getFamilyRole(String position) {
        if ((position = position.toLowerCase()).contains("aft\u00e6gtskone") || position.contains("barnepige") || position.contains("broder") || position.contains("broderdatter") || position.contains("broders\u00f8n") || position.contains("br\u00f8dre") || position.contains("datterdatter") || position.contains("for\u00e6ldre") || position.contains("manden") || position.contains("pleiebarn") || position.contains("pleieb\u00f8rn") || position.contains("pleiedatter") || position.contains("pleies\u00f8n") || position.contains("plejebarn") || position.contains("plejeb\u00f8rn") || position.contains("plejedatter") || position.contains("plejes\u00f8n") || position.contains("s\u00f8nnes\u00f8n") || position.contains("s\u00f8ster") || position.contains("s\u00f8sterdatter") || position.contains("stedfader") || position.contains("svigerfader") || position.contains("svigerfar") || position.contains("svigerfor\u00e6ldre") || position.contains("svigermoder") || position.contains("svigers\u00f8n") || position.contains("undertagskone")) {
            return "";
        }
        if (position.contains("husfader") || position.contains("huusfader")) {
            return "Fader";
        }
        if (position.contains("husmoder") || position.contains("hustru") || position.contains("huusmoder") || position.contains("kone") || position.contains("madmoder")) {
            return "Moder";
        }
        if (position.contains("barn") || position.contains("b\u00f8rn") || position.contains("datter") || position.contains("s\u00f8n")) {
            return "Barn";
        }
        return "";
    }

    public int getId() {
        return this.id;
    }

    public Individual getPerson(int i) {
        return this.persons.get(i);
    }

    public int getPersonCount() {
        return this.persons.size();
    }

    public List<Individual> getPersons() {
        return this.persons;
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    public List<Individual> getSingles() {
        return this.singles;
    }

    public boolean hasFamilies() {
        return !this.getFamilies().isEmpty();
    }

    public void setFamilies(List<Family> families) {
        this.families = families;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setPersons(List<Individual> persons) {
        this.persons = persons;
    }

    public void setRows(List<List<String>> rows) {
        this.rows = rows;
    }

    public void setSingles(List<Individual> singles) {
        this.singles = singles;
    }

    public String toString() {
        return String.valueOf(this.getRows().get(0).get(2)) + " " + this.getRows().get(0).get(3);
    }
}

