/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.gedcom;

import java.util.List;
import net.myerichsen.vejby.census.Household;

public class CensusEvent {
    private int censusYear;
    private String place;
    private Household household;

    public CensusEvent(int censusYear, String place, Household household) {
        this.censusYear = censusYear;
        this.place = place;
        this.household = household;
    }

    public int getCensusYear() {
        return this.censusYear;
    }

    public Household getHousehold() {
        return this.household;
    }

    public String getPlace() {
        return this.place;
    }

    public void setCensusYear(int censusYear) {
        this.censusYear = censusYear;
    }

    public void setHousehold(Household household) {
        this.household = household;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String toGedcom() {
        StringBuilder sb = new StringBuilder();
        sb.append("1 CENS\n");
        sb.append("2 DATE " + this.censusYear + "\n");
        sb.append("2 PLAC " + this.place + "\n");
        sb.append("2 SOUR @S1@\n");
        sb.append("3 PAGE Folket\u00e6lling " + this.censusYear + "\n");
        List<List<String>> rows = this.household.getRows();
        for (List<String> list : rows) {
            sb.append("4 CONT ");
            for (String element : list) {
                sb.append(String.valueOf(element) + ", ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

