/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.gedcom;

import java.util.ArrayList;
import java.util.List;
import net.myerichsen.vejby.gedcom.Individual;

public class Family {
    private Individual father;
    private Individual mother;
    private List<Individual> children = new ArrayList<Individual>();
    private List<Individual> singles = new ArrayList<Individual>();
    private int householdId;
    private int familyId;
    private String marriageDate = "";
    private String marriagePlace = "";

    public Family(int householdId, int familyId) {
        this.setHouseholdId(householdId);
        this.setFamilyId(familyId);
    }

    public List<Individual> getChildren() {
        return this.children;
    }

    public int getFamilyId() {
        return this.familyId;
    }

    public Individual getFather() {
        return this.father;
    }

    public int getHouseholdId() {
        return this.householdId;
    }

    public String getMarriageDate() {
        return this.marriageDate;
    }

    public String getMarriagePlace() {
        return this.marriagePlace;
    }

    public String[][] getMembers() {
        String[][] members = new String[this.getSize()][5];
        int index = 0;
        if (this.father != null) {
            members[index][0] = String.valueOf(this.father.getId());
            members[index][1] = this.father.getName();
            members[index][2] = this.father.getMaritalStatus();
            members[index][3] = this.father.getTrade();
            members[index++][4] = "Fader";
        }
        if (this.mother != null) {
            members[index][0] = String.valueOf(this.mother.getId());
            members[index][1] = this.mother.getName();
            members[index][2] = this.mother.getMaritalStatus();
            members[index][3] = this.mother.getTrade();
            members[index++][4] = "Moder";
        }
        for (Individual child : this.children) {
            members[index][0] = String.valueOf(child.getId());
            members[index][1] = child.getName();
            members[index][2] = child.getMaritalStatus();
            members[index][3] = child.getTrade();
            members[index++][4] = "Barn";
        }
        for (Individual single : this.singles) {
            members[index][0] = String.valueOf(single.getId());
            members[index][1] = single.getName();
            members[index][2] = single.getMaritalStatus();
            members[index][3] = single.getTrade();
            members[index++][4] = "";
        }
        return members;
    }

    public Individual getMother() {
        return this.mother;
    }

    public List<Individual> getSingles() {
        return this.singles;
    }

    public int getSize() {
        int size = 0;
        if (this.father != null) {
            ++size;
        }
        if (this.mother != null) {
            ++size;
        }
        size += this.children.size();
        return size += this.singles.size();
    }

    public void removeIndividual(Individual individual) {
        if (this.getFather() != null && this.getFather().equals(individual)) {
            this.setFather(null);
        }
        if (this.getMother() != null && this.getMother().equals(individual)) {
            this.setMother(null);
        }
        for (Individual child : this.children) {
            if (!child.equals(individual)) continue;
            this.children.remove(individual);
        }
        for (Individual single : this.singles) {
            if (!single.equals(individual)) continue;
            this.singles.remove(individual);
        }
    }

    public void setChild(Individual child) {
        this.children.add(child);
    }

    public void setChildren(List<Individual> children) {
        this.children = children;
    }

    public void setFamilyId(int familyId) {
        this.familyId = familyId;
    }

    public void setFather(Individual father) {
        this.father = father;
    }

    public void setHouseholdId(int householdId) {
        this.householdId = householdId;
    }

    public void setMarriageDate(String marriageDate) {
        this.marriageDate = marriageDate;
    }

    public void setMarriagePlace(String marriagePlace) {
        this.marriagePlace = marriagePlace;
    }

    public void setMother(Individual mother) {
        this.mother = mother;
    }

    public void setSingles(List<Individual> singles) {
        this.singles = singles;
    }

    public String toGedcom(int familyId) {
        StringBuilder sb = new StringBuilder();
        if (this.father != null) {
            sb.append(this.father.toGedcom());
            sb.append("1 FAMS @F" + familyId + "@\n");
        }
        if (this.mother != null) {
            sb.append(this.mother.toGedcom());
            sb.append("1 FAMS @F" + familyId + "@\n");
        }
        for (Individual child : this.children) {
            sb.append(child.toGedcom());
            sb.append("1 FAMC @F" + familyId + "@\n");
        }
        sb.append("0 @F" + familyId + "@ FAM\n");
        if (this.father != null) {
            sb.append("1 HUSB @I" + this.father.getId() + "@\n");
        }
        if (this.mother != null) {
            sb.append("1 WIFE @I" + this.mother.getId() + "@\n");
        }
        for (Individual child : this.children) {
            sb.append("1 CHIL @I" + child.getId() + "@\n");
        }
        sb.append("1 MARR\n");
        if (!this.marriageDate.equals("")) {
            sb.append("2 DATE " + this.marriageDate + "\n");
        }
        if (!this.marriagePlace.equals("")) {
            sb.append("2 PLAC " + this.marriagePlace + "\n");
        }
        sb.append("2 SOUR @S1@\n");
        return sb.toString();
    }

    public String toString() {
        if (this.familyId == 0) {
            return "Uden for familien";
        }
        if (this.father != null) {
            return this.father.toString();
        }
        if (this.mother != null) {
            return this.mother.toString();
        }
        return "";
    }
}

