/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.gedcom;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.myerichsen.vejby.census.Census;
import net.myerichsen.vejby.gedcom.Family;
import net.myerichsen.vejby.gedcom.Individual;

public class GedcomFile {
    private static final Logger LOGGER = Logger.getLogger("global");
    private Preferences prefs = Preferences.userRoot().node("net.myerichsen.vejby.gedcom");
    private List<Family> families;

    public GedcomFile() {
        this.setFamilies(new ArrayList<Family>());
    }

    public void addFamily(Family family) {
        this.families.add(family);
    }

    public List<Family> getFamilies() {
        return this.families;
    }

    public String saveCensus(Census censusTable) {
        FileNameExtensionFilter ff = new FileNameExtensionFilter("GEDCOM fil", "ged");
        JFileChooser gedcomChooser = new JFileChooser(this.prefs.get("GEDCOMFILENAME", "."));
        String path = "";
        gedcomChooser.setFileFilter(ff);
        int returnValue = gedcomChooser.showSaveDialog(null);
        if (returnValue == 0) {
            File gedcomFile = gedcomChooser.getSelectedFile();
            String fileName = gedcomFile.getName();
            if (!fileName.endsWith(".ged")) {
                gedcomFile = new File(String.valueOf(fileName) + ".ged");
            }
            this.prefs.put("GEDCOMFILENAME", gedcomFile.getPath());
            OutputStreamWriter fw = null;
            try {
                fw = new OutputStreamWriter((OutputStream)new FileOutputStream(gedcomFile), "ANSEL");
                fw.write("0 HEAD\n");
                fw.write("1 SOUR VejbyGedcom\n");
                fw.write("2 VERS v 0.1\n");
                fw.write("1 SUBM @SUB1@\n");
                fw.write("1 GEDC\n");
                fw.write("2 VERS 5.5\n");
                fw.write("2 FORM LINEAGE-LINKED\n");
                fw.write("1 DEST GED55\n");
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy");
                fw.write("1 DATE " + sdf.format(cal.getTime()) + "\n");
                sdf = new SimpleDateFormat("hh:mm");
                fw.write("2 TIME " + sdf.format(cal.getTime()) + "\n");
                fw.write("1 CHAR ANSEL\n");
                fw.write("1 FILE " + fileName + "\n");
                fw.write("0 @SUB1@ SUBM\n");
                fw.write("1 NAME Dansk Demografisk Database\n");
                fw.write("1 ADDR Rigsarkivet, Jernbanegade 36, 5000 Odense C\n");
                int familyId = 1;
                for (Family family : censusTable.getFamilies()) {
                    if (family.getFamilyId() == 0) {
                        for (Individual person : family.getSingles()) {
                            LOGGER.log(Level.FINE, "Writing GEDCOM for person " + person.getId() + ", " + person);
                            fw.write(person.toGedcom());
                            LOGGER.log(Level.FINE, "Family " + family.getHouseholdId() + ", " + family.getFamilyId() + ", " + person.toString());
                        }
                        continue;
                    }
                    fw.write(family.toGedcom(familyId++));
                    LOGGER.log(Level.FINE, "Family " + family.getHouseholdId() + ", " + family.getFamilyId() + ", " + family.toString());
                }
                fw.write("1 TITL DDD Folket\u00e6llinger. Kildeindtastningsprojektet.\n");
                fw.write("1 AUTH Statens Arkiver\n");
                fw.write("0 TRLR\n");
                fw.close();
                path = gedcomFile.getPath();
                LOGGER.log(Level.INFO, "Data gemt som GEDCOM fil " + path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    public String saveFsExtract(String fileNameStub) {
        FileNameExtensionFilter ff = new FileNameExtensionFilter("GEDCOM fil", "ged");
        JFileChooser gedcomChooser = new JFileChooser(this.prefs.get("GEDCOMFILENAME", "."));
        gedcomChooser.setSelectedFile(new File(String.valueOf(fileNameStub) + ".ged"));
        String path = "";
        gedcomChooser.setFileFilter(ff);
        int returnValue = gedcomChooser.showSaveDialog(null);
        if (returnValue == 0) {
            File gedcomFile = gedcomChooser.getSelectedFile();
            String fileName = gedcomFile.getName();
            if (!fileName.endsWith(".ged")) {
                gedcomFile = new File(String.valueOf(fileName) + ".ged");
            }
            this.prefs.put("GEDCOMFILENAME", gedcomFile.getPath());
            try {
                OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(gedcomFile));
                writer.write("0 HEAD\n");
                writer.write("1 SOUR VejbyGedcom\n");
                writer.write("2 VERS v 0.1\n");
                writer.write("1 SUBM @SUB1@\n");
                writer.write("1 GEDC\n");
                writer.write("2 VERS 5.5\n");
                writer.write("2 FORM LINEAGE-LINKED\n");
                writer.write("1 DEST GED55\n");
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy");
                writer.write("1 DATE " + sdf.format(cal.getTime()) + "\n");
                sdf = new SimpleDateFormat("hh:mm");
                writer.write("2 TIME " + sdf.format(cal.getTime()) + "\n");
                writer.write("1 CHAR ANSEL\n");
                writer.write("1 FILE " + fileName + "\n");
                writer.write("0 @SUB1@ SUBM\n");
                writer.write("1 NAME Intellectual Reserve, Inc.\n");
                writer.write("1 ADDR Salt Lake City, USA\n");
                String s = "";
                int i = 0;
                while (i < this.families.size()) {
                    Family family = this.families.get(i);
                    LOGGER.log(Level.FINE, "Family " + i);
                    s = family.toGedcom(i);
                    writer.write(s);
                    LOGGER.log(Level.FINE, "Family " + family.getHouseholdId() + ", " + family.getFamilyId() + ", " + family.toString());
                    ++i;
                }
                writer.write("0 @S1@ SOUR\n");
                writer.write("1 TITL FamilySearch (https://familysearch.org/)\n");
                writer.write("1 AUTH Intellectual Reserve, Inc.\n");
                writer.write("0 TRLR\n");
                writer.close();
                path = gedcomFile.getPath();
                LOGGER.log(Level.INFO, "Data gemt som GEDCOM fil " + path);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                return "";
            }
        }
        return path;
    }

    public void setFamilies(List<Family> families) {
        this.families = families;
    }
}

