/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.gedcom;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.myerichsen.vejby.census.Household;
import net.myerichsen.vejby.gedcom.CensusEvent;
import net.myerichsen.vejby.util.Mapping;

public class Individual {
    private static final Logger LOGGER = Logger.getLogger("global");
    private int id;
    private String name = "";
    private String sex = "";
    private String trade = "";
    private String position = "";
    private String address = "";
    private String birthDate = "";
    private String birthPlace = "";
    private String christeningDate = "";
    private String christeningPlace = "";
    private String confirmationDate = "";
    private String confirmationPlace = "";
    private String deathDate = "";
    private String deathPlace = "";
    private String place = "";
    private String maritalStatus = "";
    private String familyRole1 = "";
    private String familyRole2 = "";
    private String familyRole3 = "";
    private String familyRole4 = "";
    private String source = "";
    private int year;
    private Household household;
    private CensusEvent censusEvent;

    public Individual(int id) {
        this.id = id;
    }

    public String getAddress() {
        return this.address;
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public String getBirthPlace() {
        return this.birthPlace;
    }

    public CensusEvent getCensusEvent() {
        return this.censusEvent;
    }

    public String getChristeningDate() {
        return this.christeningDate;
    }

    public String getChristeningPlace() {
        return this.christeningPlace;
    }

    public String getConfirmationDate() {
        return this.confirmationDate;
    }

    public String getConfirmationPlace() {
        return this.confirmationPlace;
    }

    public String getDeathDate() {
        return this.deathDate;
    }

    public String getDeathPlace() {
        return this.deathPlace;
    }

    public String getFamilyRole1() {
        return this.familyRole1;
    }

    public String getFamilyRole2() {
        return this.familyRole2;
    }

    public String getFamilyRole3() {
        return this.familyRole3;
    }

    public String getFamilyRole4() {
        return this.familyRole4;
    }

    public Household getHousehold() {
        return this.household;
    }

    public int getId() {
        return this.id;
    }

    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getPlace() {
        return this.place;
    }

    public String getPosition() {
        return this.position;
    }

    public String getSex() {
        return this.sex;
    }

    public String getSource() {
        return this.source;
    }

    public String getTrade() {
        return this.trade;
    }

    public int getYear() {
        return this.year;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setBirthDate(String birthDate) {
        this.birthDate = birthDate;
    }

    public void setBirthPlace(String birthPlace) {
        this.birthPlace = birthPlace;
    }

    public void setCensusEvent(CensusEvent censusEvent) {
        this.censusEvent = censusEvent;
    }

    public void setChristeningDate(String christeningDate) {
        this.christeningDate = christeningDate;
    }

    public void setChristeningPlace(String christeningPlace) {
        this.christeningPlace = christeningPlace;
    }

    public void setConfirmationDate(String confirmationDate) {
        this.confirmationDate = confirmationDate;
    }

    public void setConfirmationPlace(String confirmationPlace) {
        this.confirmationPlace = confirmationPlace;
    }

    public void setDeathDate(String deathDate) {
        this.deathDate = deathDate;
    }

    public void setDeathPlace(String deathPlace) {
        this.deathPlace = deathPlace;
    }

    public void setFamilyRole1(String familyRole1) {
        this.familyRole1 = familyRole1;
    }

    public void setFamilyRole2(String familyRole2) {
        this.familyRole2 = familyRole2;
    }

    public void setFamilyRole3(String familyRole3) {
        this.familyRole3 = familyRole3;
    }

    public void setFamilyRole4(String familyRole4) {
        this.familyRole4 = familyRole4;
    }

    public void setHousehold(Household household) {
        this.household = household;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTrade(String trade) {
        this.trade = trade;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String toGedcom() {
        Mapping mapping = Mapping.getInstance();
        StringBuffer sb = new StringBuffer();
        sb.append("0 @I" + this.getId() + "@ INDI\n");
        sb.append("1 NAME ");
        String[] nameParts = this.getName().split(" ");
        String familyName = nameParts[nameParts.length - 1];
        LOGGER.log(Level.FINE, "Family name: " + familyName);
        if (familyName.endsWith("d.")) {
            familyName = familyName.replace("d.", "datter");
        } else if (familyName.endsWith("dat.")) {
            familyName = familyName.replace("dat.", "datter");
        } else if (familyName.endsWith("dat")) {
            familyName = familyName.replace("dat", "datter");
        } else if (familyName.endsWith("datt.")) {
            familyName = familyName.replace("datt.", "datter");
        } else if (familyName.endsWith("datt")) {
            familyName = familyName.replace("datt", "datter");
        } else if (familyName.endsWith("datr.")) {
            familyName = familyName.replace("datr.", "datter");
        } else if (familyName.endsWith("datr")) {
            familyName = familyName.replace("datr", "datter");
        } else if (familyName.endsWith("dtr.")) {
            familyName = familyName.replace("dtr.", "datter");
        } else if (familyName.endsWith("dtr")) {
            familyName = familyName.replace("dtr", "datter");
        }
        if (mapping.getDaughterNameStubs().contains(familyName.toLowerCase())) {
            LOGGER.log(Level.INFO, "Invalid family name: " + familyName);
            familyName = new String(String.valueOf(nameParts[nameParts.length - 2]) + "datter");
            int i = 0;
            while (i < nameParts.length - 2) {
                sb.append(String.valueOf(nameParts[i]) + " ");
                ++i;
            }
        } else {
            int i = 0;
            while (i < nameParts.length - 1) {
                sb.append(String.valueOf(nameParts[i]) + " ");
                ++i;
            }
        }
        sb.append("/" + familyName + "/\n");
        if (this.getSource() != null && !this.getSource().equals("")) {
            sb.append("2 SOUR @S1@\n");
            sb.append("3 PAGE " + this.getSource() + "\n");
        }
        if (this.getSex().equals("K") || this.getSex().equals("F")) {
            sb.append("1 SEX F\n");
        } else {
            sb.append("1 SEX M\n");
        }
        if (this.getBirthDate() != null && !this.getBirthDate().equals("")) {
            sb.append("1 BIRT\n");
            sb.append("2 DATE " + this.getBirthDate() + "\n");
            if (this.getBirthPlace() != null && !this.getBirthPlace().equals("")) {
                sb.append("2 PLAC " + this.getBirthPlace() + ",\n");
            }
        }
        if (this.getChristeningDate() != null && !this.getChristeningDate().equals("")) {
            sb.append("1 CHR\n");
            sb.append("2 DATE " + this.getChristeningDate() + "\n");
            if (this.getChristeningPlace() != null && !this.getChristeningPlace().equals("")) {
                sb.append("2 PLAC " + this.getChristeningPlace() + ",\n");
            }
            sb.append("2 SOUR @S1@\n");
        }
        if (this.getConfirmationDate() != null && !this.getConfirmationDate().equals("")) {
            sb.append("1 CONF\n");
            sb.append("2 DATE " + this.getConfirmationDate() + "\n");
            if (this.getConfirmationPlace() != null && !this.getConfirmationPlace().equals("")) {
                sb.append("2 PLAC " + this.getConfirmationPlace() + ",\n");
            }
            sb.append("2 SOUR @S1@\n");
        }
        if (this.getDeathDate() != null && !this.getDeathDate().equals("")) {
            sb.append("1 DEAT\n");
            sb.append("2 DATE " + this.getDeathDate() + "\n");
            if (this.getDeathPlace() != null && !this.getDeathPlace().equals("")) {
                sb.append("2 PLAC " + this.getDeathPlace() + "\n");
            }
            sb.append("2 SOUR @S1@\n");
        }
        if (this.getTrade() != null && !this.getTrade().equals("")) {
            sb.append("1 OCCU " + this.getTrade() + "\n");
        }
        if (this.censusEvent != null) {
            sb.append(this.censusEvent.toGedcom());
        }
        return sb.toString();
    }

    public String toString() {
        return this.name;
    }
}

