/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import net.myerichsen.vejby.gedcom.Family;
import net.myerichsen.vejby.gedcom.GedcomFile;
import net.myerichsen.vejby.gedcom.Individual;
import net.myerichsen.vejby.ui.FsPanel;

public class BirthPanel
extends FsPanel {
    private static final long serialVersionUID = 3673964025732718748L;

    public BirthPanel() {
        this.dataArray = new String[0][8];
        this.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "Center");
        this.table = new JTable();
        scrollPane.setViewportView(this.table);
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        JButton openButton = new JButton("\u00c5ben Family Search eksport fil");
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BirthPanel.this.openTsvFile();
            }
        });
        buttonPanel.add(openButton);
        this.eliminateButton = new JButton("Fjern dubletter");
        this.eliminateButton.setEnabled(false);
        this.eliminateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BirthPanel.this.eliminateDuplicates();
            }
        });
        buttonPanel.add(this.eliminateButton);
        this.saveButton = new JButton("Gem som Gedcom");
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BirthPanel.this.saveAsGedcom();
            }
        });
        buttonPanel.add(this.saveButton);
    }

    @Override
    protected void openTsvFile() {
        this.headerArray = new String[8];
        FileNameExtensionFilter ff = new FileNameExtensionFilter("FS eksport fil (TSV)", "tsv");
        String fsFileName = this.prefs.get("FSFILENAME", ".");
        String[][] birthArray = new String[100][8];
        JFileChooser fsChooser = new JFileChooser(fsFileName);
        fsChooser.setFileFilter(ff);
        fsChooser.setMultiSelectionEnabled(true);
        int returnValue = fsChooser.showOpenDialog(null);
        if (returnValue == 0) {
            File[] fsFiles = fsChooser.getSelectedFiles();
            this.fileNameStub = fsFiles[0].getName().replaceFirst("[.][^.]+$", "");
            LOGGER.log(Level.FINE, fsFiles[0].getPath());
            this.prefs.put("KIPFILENAME", fsFiles[0].getPath());
            int fileNo = 0;
            while (fileNo < fsFiles.length) {
                try {
                    birthArray = new String[100][8];
                    FileInputStream fis = new FileInputStream(fsFiles[fileNo]);
                    Scanner sc = new Scanner(fis);
                    String[] columns = sc.nextLine().split("\t");
                    if (fileNo == 0) {
                        this.headerArray[0] = columns[8];
                        this.headerArray[1] = columns[9];
                        this.headerArray[2] = columns[10];
                        this.headerArray[3] = columns[11];
                        this.headerArray[4] = columns[12];
                        this.headerArray[5] = columns[13];
                        this.headerArray[6] = columns[22];
                        this.headerArray[7] = columns[23];
                    }
                    sc.nextLine();
                    int i = 0;
                    while (sc.hasNext()) {
                        columns = sc.nextLine().split("\t");
                        birthArray[i][0] = this.fixCodePage(columns, 8);
                        birthArray[i][1] = columns[9];
                        birthArray[i][2] = columns[10];
                        birthArray[i][3] = this.fixCodePage(columns, 11);
                        birthArray[i][4] = columns[12];
                        birthArray[i][5] = this.fixCodePage(columns, 13);
                        birthArray[i][6] = this.fixCodePage(columns, 22);
                        birthArray[i][7] = this.fixCodePage(columns, 23);
                        ++i;
                    }
                    sc.close();
                    fis.close();
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                }
                this.dataArray = (String[][])this.concatenate((T[])this.dataArray, (T[])birthArray);
                LOGGER.log(Level.FINE, "Data array length after concatenation: " + this.dataArray.length);
                ++fileNo;
            }
            LOGGER.log(Level.INFO, "Data array length after concatenations: " + this.dataArray.length);
        }
        DefaultTableModel model = new DefaultTableModel(this.dataArray, this.headerArray);
        this.table.setModel(model);
        this.saveButton.setEnabled(true);
        this.eliminateButton.setEnabled(true);
    }

    @Override
    protected void saveAsGedcom() {
        GedcomFile gedcomFile = new GedcomFile();
        Individual child = null;
        Individual father = null;
        Individual mother = null;
        int individualId = 1;
        String[] line = new String[8];
        int i = 0;
        while (i < this.dataArray.length) {
            line = this.dataArray[i];
            Family family = new Family(0, i);
            child = new Individual(individualId++);
            String childName = line[0];
            if (childName != null) {
                String[] childNamePart = childName.split(" ");
                if (childNamePart.length == 1) {
                    child.setName(String.valueOf(childName) + " ?");
                } else if (childName.endsWith("sen") || childName.endsWith("datter") || childName.endsWith("dtr") || childName.endsWith("d") || childName.endsWith("D") || childName.endsWith("son")) {
                    child.setName(childName);
                } else {
                    child.setName(String.valueOf(childName) + " ?");
                }
                child.setSex(line[1].equals("male") ? "M" : "F");
                child.setBirthDate(line[2]);
                child.setBirthPlace(line[3]);
                child.setChristeningDate(line[4]);
                child.setChristeningPlace(line[5]);
                family.getChildren().add(child);
                if (!line[6].equals("")) {
                    father = new Individual(individualId++);
                    father.setName(line[6]);
                    father.setSex("M");
                    family.setFather(father);
                }
                if (!line[7].equals("")) {
                    mother = new Individual(individualId++);
                    mother.setName(line[7]);
                    mother.setSex("F");
                    family.setMother(mother);
                }
                gedcomFile.addFamily(family);
            }
            ++i;
        }
        String path = gedcomFile.saveFsExtract(this.fileNameStub);
        if (!path.equals("")) {
            JOptionPane.showMessageDialog(new JFrame(), "F\u00f8dsler er gemt som GEDCOM fil " + path, "Vejby Gedcom", 1);
        }
    }
}

