/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import net.myerichsen.vejby.gedcom.Family;
import net.myerichsen.vejby.gedcom.GedcomFile;
import net.myerichsen.vejby.gedcom.Individual;
import net.myerichsen.vejby.ui.FsPanel;

public class BurialPanel
extends FsPanel {
    private static final long serialVersionUID = 3673964025732718748L;

    public BurialPanel() {
        this.dataArray = new String[0][5];
        this.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "Center");
        this.table = new JTable();
        scrollPane.setViewportView(this.table);
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        JButton openButton = new JButton("\u00c5ben Family Search eksport fil");
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BurialPanel.this.openTsvFile();
            }
        });
        buttonPanel.add(openButton);
        this.eliminateButton = new JButton("Fjern dubletter");
        this.eliminateButton.setEnabled(false);
        this.eliminateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BurialPanel.this.eliminateDuplicates();
            }
        });
        buttonPanel.add(this.eliminateButton);
        this.saveButton = new JButton("Gem som Gedcom");
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BurialPanel.this.saveAsGedcom();
            }
        });
        buttonPanel.add(this.saveButton);
    }

    @Override
    protected void openTsvFile() {
        this.headerArray = new String[5];
        FileNameExtensionFilter ff = new FileNameExtensionFilter("FS eksport fil (TSV)", "tsv");
        String fsFileName = this.prefs.get("FSFILENAME", ".");
        String[][] burialArray = new String[100][5];
        JFileChooser fsChooser = new JFileChooser(fsFileName);
        fsChooser.setFileFilter(ff);
        fsChooser.setMultiSelectionEnabled(true);
        int returnValue = fsChooser.showOpenDialog(null);
        if (returnValue == 0) {
            File[] fsFiles = fsChooser.getSelectedFiles();
            this.fileNameStub = fsFiles[0].getName().replaceFirst("[.][^.]+$", "");
            LOGGER.log(Level.FINE, fsFiles[0].getPath());
            this.prefs.put("KIPFILENAME", fsFiles[0].getPath());
            int fileNo = 0;
            while (fileNo < fsFiles.length) {
                try {
                    burialArray = new String[100][5];
                    FileInputStream fis = new FileInputStream(fsFiles[fileNo]);
                    Scanner sc = new Scanner(fis);
                    String[] columnLabels = sc.nextLine().split("\t");
                    if (fileNo == 0) {
                        this.headerArray[0] = columnLabels[8];
                        this.headerArray[1] = columnLabels[9];
                        this.headerArray[2] = columnLabels[10];
                        this.headerArray[3] = columnLabels[18];
                        this.headerArray[4] = columnLabels[19];
                    }
                    sc.nextLine();
                    int i = 0;
                    while (sc.hasNext()) {
                        String[] columns = sc.nextLine().split("\t");
                        burialArray[i][0] = this.fixCodePage(columns, 8);
                        burialArray[i][1] = columns[9];
                        burialArray[i][2] = columns[10];
                        burialArray[i][3] = columns[18];
                        burialArray[i][4] = this.fixCodePage(columns, 19);
                        ++i;
                    }
                    sc.close();
                    fis.close();
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                }
                this.dataArray = (String[][])this.concatenate((T[])this.dataArray, (T[])burialArray);
                LOGGER.log(Level.FINE, "Data array length after concatenation: " + this.dataArray.length);
                ++fileNo;
            }
            LOGGER.log(Level.INFO, "Data array length after concatenations: " + this.dataArray.length);
        }
        DefaultTableModel model = new DefaultTableModel(this.dataArray, this.headerArray);
        this.table.setModel(model);
        this.saveButton.setEnabled(true);
        this.eliminateButton.setEnabled(true);
    }

    @Override
    protected void saveAsGedcom() {
        GedcomFile gedcomFile = new GedcomFile();
        Individual deceased = null;
        int individualId = 1;
        String[] line = new String[5];
        int i = 0;
        while (i < this.dataArray.length) {
            line = this.dataArray[i];
            Family family = new Family(0, i);
            deceased = new Individual(individualId++);
            String deceasedName = line[0];
            if (deceasedName != null) {
                String[] deceasedNamePart = deceasedName.split(" ");
                if (deceasedNamePart.length == 1) {
                    deceased.setName(String.valueOf(deceasedName) + " ?");
                } else if (deceasedName.endsWith("sen") || deceasedName.endsWith("datter") || deceasedName.endsWith("dtr") || deceasedName.endsWith("d") || deceasedName.endsWith("D") || deceasedName.endsWith("son")) {
                    deceased.setName(deceasedName);
                } else {
                    deceased.setName(String.valueOf(deceasedName) + " ?");
                }
                deceased.setSex(line[1].equals("male") ? "M" : "F");
                deceased.setBirthDate(line[2]);
                deceased.setDeathDate(line[3]);
                deceased.setDeathPlace(line[4]);
                if (deceased.getSex().equals("M")) {
                    family.setFather(deceased);
                } else {
                    family.setMother(deceased);
                }
                gedcomFile.addFamily(family);
            }
            ++i;
        }
        String path = gedcomFile.saveFsExtract(this.fileNameStub);
        if (!path.equals("")) {
            JOptionPane.showMessageDialog(new JFrame(), String.valueOf(individualId - 1) + " d\u00f8dsfald er gemt som GEDCOM fil " + path, "Vejby Gedcom", 1);
        }
    }
}

