/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.myerichsen.vejby.census.Census;
import net.myerichsen.vejby.census.Household;
import net.myerichsen.vejby.ui.VejbyGedcom;
import net.myerichsen.vejby.util.CustomTableCellRenderer;
import net.myerichsen.vejby.util.Mapping;

public class CensusMappingPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger("global");
    private static final long serialVersionUID = -2181211331271971240L;
    private Preferences prefs = Preferences.userRoot().node("net.myerichsen.vejby.gedcom");
    private Mapping mapping;
    private int[] mappingKeys;
    private JTable mappingTable;
    private DefaultTableModel mappingModel;
    private CustomTableCellRenderer renderer;
    private VejbyGedcom vejbyGedcom;

    public CensusMappingPanel(final VejbyGedcom vejbyGedcom) {
        this.vejbyGedcom = vejbyGedcom;
        this.mapping = Mapping.getInstance();
        this.mappingKeys = this.mapping.getMappingKeys();
        this.setLayout(new BorderLayout(0, 0));
        JScrollPane mappingScrollPane = new JScrollPane();
        this.add((Component)mappingScrollPane, "Center");
        this.mappingTable = new JTable();
        mappingScrollPane.setViewportView(this.mappingTable);
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        JButton btnAnalysr = new JButton("Analys\u00e9r");
        btnAnalysr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CensusMappingPanel.this.populateMappingFromTable() && CensusMappingPanel.this.identifyHouseholds()) {
                    vejbyGedcom.getHouseholdJPanel().populateTree();
                    JTabbedPane pane = vejbyGedcom.getTabbedPane();
                    pane.setEnabledAt(3, true);
                    pane.setSelectedIndex(3);
                }
            }
        });
        buttonPanel.add(btnAnalysr);
    }

    protected boolean identifyHouseholds() {
        if (this.mappingKeys[3] == 0) {
            JOptionPane.showMessageDialog(new JFrame(), "Husstandsnummer kan ikke mappes", "Vejby Gedcom", 2);
            return false;
        }
        Census censusTable = this.vejbyGedcom.getCensusJPanel().getCensusTable();
        String message = censusTable.createHouseholds(this.mappingKeys[3]);
        LOGGER.log(Level.INFO, message);
        if (this.mappingKeys[5] != 0) {
            for (Household household : censusTable.getHouseholds()) {
                message = household.createFamilies(this.mappingKeys[5]);
                LOGGER.log(Level.FINE, message);
            }
        } else {
            for (Household household : censusTable.getHouseholds()) {
                message = household.createFamilies(-1);
                LOGGER.log(Level.FINE, message);
            }
        }
        return true;
    }

    private boolean populateMappingFromTable() {
        int i = 0;
        while (i < this.mappingTable.getRowCount()) {
            String value = (String)this.mappingTable.getValueAt(i, 2);
            if (value.equals("Bruges ikke")) {
                this.mappingKeys[0] = i;
                this.prefs.putInt("Bruges ikke", i);
            } else if (value.equals("Personid")) {
                this.mappingKeys[1] = i;
                this.prefs.putInt("Personid", i);
            } else if (value.equals("Sted")) {
                this.mappingKeys[2] = i;
                this.prefs.putInt("Sted", i);
            } else if (value.equals("Husstandsnr")) {
                this.mappingKeys[3] = i;
                this.prefs.putInt("Husstandsnr", i);
            } else if (value.equals("Navn")) {
                this.mappingKeys[4] = i;
                this.prefs.putInt("Navn", i);
            } else if (value.equals("K\u00f8n")) {
                this.mappingKeys[5] = i;
                this.prefs.putInt("K\u00f8n", i);
            } else if (value.equals("F\u00f8dsels\u00e5r")) {
                this.mappingKeys[6] = i;
                this.prefs.putInt("F\u00f8dsels\u00e5r", i);
            } else if (value.equals("Alder")) {
                this.mappingKeys[7] = i;
                this.prefs.putInt("Alder", i);
            } else if (value.equals("Civilstand")) {
                this.mappingKeys[8] = i;
                this.prefs.putInt("Civilstand", i);
            } else if (value.equals("Erhverv")) {
                this.mappingKeys[9] = i;
                this.prefs.putInt("Erhverv", i);
            } else if (value.equals("Position")) {
                this.mappingKeys[10] = i;
                this.prefs.putInt("Position", i);
            } else if (value.equals("F\u00f8dested")) {
                this.mappingKeys[11] = i;
                this.prefs.putInt("F\u00f8dested", i);
            } else if (value.equals("FT\u00c5r")) {
                this.mappingKeys[12] = i;
                this.prefs.putInt("FT\u00c5r", i);
            }
            ++i;
        }
        boolean found = false;
        String error = "";
        int i2 = 0;
        while (i2 < this.mappingKeys.length) {
            int j = i2 + 1;
            while (j < this.mappingKeys.length) {
                if (this.mappingKeys[i2] != 0 && this.mappingKeys[i2] == this.mappingKeys[j]) {
                    found = true;
                    error = "Samme v\u00e6rdi (" + this.mappingKeys[i2] + ") er brugt b\u00e5de i " + (i2 + 1) + ". og " + (j + 1) + ". r\u00e6kke";
                }
                ++j;
            }
            ++i2;
        }
        if (found) {
            JOptionPane.showMessageDialog(new JFrame(), error, "Vejby Gedcom", 0);
        }
        LOGGER.log(Level.INFO, this.mapping.toString());
        return !found;
    }

    public void populateMappingTable(DefaultTableModel censusModel) {
        Object[] columnNames = new String[]{"Nr.", "FT kolonne", "GEDCOM kolonne"};
        ArrayList<String> headers = new ArrayList<String>();
        int i = 0;
        while (i < censusModel.getColumnCount()) {
            headers.add(censusModel.getColumnName(i));
            ++i;
        }
        int rowCount = headers.size();
        Object[][] mappingArray = new String[rowCount][columnNames.length];
        int i2 = 0;
        while (i2 < rowCount) {
            mappingArray[i2][0] = Integer.toString(i2 + 1);
            mappingArray[i2][1] = (String)headers.get(i2);
            int j = 2;
            while (j < columnNames.length) {
                mappingArray[i2][j] = "Bruges ikke";
                ++j;
            }
            ++i2;
        }
        this.mappingModel = new DefaultTableModel(mappingArray, columnNames);
        this.renderer = new CustomTableCellRenderer();
        this.mappingTable.setModel(this.mappingModel);
        this.mappingTable.getColumnModel().getColumn(2).setCellRenderer(this.renderer);
        JComboBox<String> individualcomboBox = new JComboBox<String>();
        individualcomboBox.addItem("Bruges ikke");
        individualcomboBox.addItem("Personid");
        individualcomboBox.addItem("Sted");
        individualcomboBox.addItem("Husstandsnr");
        individualcomboBox.addItem("Navn");
        individualcomboBox.addItem("K\u00f8n");
        individualcomboBox.addItem("F\u00f8dsels\u00e5r");
        individualcomboBox.addItem("Alder");
        individualcomboBox.addItem("Civilstand");
        individualcomboBox.addItem("Erhverv");
        individualcomboBox.addItem("Position");
        individualcomboBox.addItem("F\u00f8dested");
        individualcomboBox.addItem("FT\u00c5r");
        this.mappingTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(individualcomboBox));
        this.setValuesFromPreferences();
    }

    private void setValuesFromPreferences() {
        int maxSize = this.mappingTable.getModel().getRowCount();
        LOGGER.log(Level.FINE, "Mapping table row count: " + maxSize);
        int row = this.prefs.getInt("Bruges ikke", 0);
        if (row > 0 && row < maxSize) {
            this.mappingTable.setValueAt("Bruges ikke", row, 2);
            this.renderer.setRowColor(row, Color.WHITE);
        }
        if ((row = this.prefs.getInt("Personid", 0)) > 0 && row < maxSize) {
            this.mappingTable.setValueAt("Personid", row, 2);
            this.renderer.setRowColor(row, Color.ORANGE);
        }
        if ((row = this.prefs.getInt("Sted", 0)) > 0 && row < maxSize) {
            this.mappingTable.setValueAt("Sted", row, 2);
            this.renderer.setRowColor(row, Color.ORANGE);
        }
        if ((row = this.prefs.getInt("Husstandsnr", 0)) > 0 && row < maxSize) {
            this.mappingTable.setValueAt("Husstandsnr", row, 2);
            this.renderer.setRowColor(row, Color.ORANGE);
        }
        if ((row = this.prefs.getInt("Navn", 0)) > 0 && row < maxSize) {
            this.mappingTable.setValueAt("Navn", row, 2);
            this.renderer.setRowColor(row, Color.ORANGE);
        }
        if ((row = this.prefs.getInt("K\u00f8n", 0)) > 0 && row < maxSize) {
            this.mappingTable.setValueAt("K\u00f8n", row, 2);
            this.renderer.setRowColor(row, Color.ORANGE);
        }
        if ((row = this.prefs.getInt("F\u00f8dsels\u00e5r", 0)) > 0 && row < maxSize) {
            this.mappingTable.setValueAt("F\u00f8dsels\u00e5r", row, 2);
            this.renderer.setRowColor(row, Color.ORANGE);
        }
        if ((row = this.prefs.getInt("Alder", 0)) > 0 && row < maxSize) {
            this.mappingTable.setValueAt("Alder", row, 2);
            this.renderer.setRowColor(row, Color.ORANGE);
        }
        if ((row = this.prefs.getInt("Civilstand", 0)) > 0 && row < maxSize) {
            this.mappingTable.setValueAt("Civilstand", row, 2);
            this.renderer.setRowColor(row, Color.ORANGE);
        }
        if ((row = this.prefs.getInt("Erhverv", 0)) > 0 && row < maxSize) {
            this.mappingTable.setValueAt("Erhverv", row, 2);
            this.renderer.setRowColor(row, Color.ORANGE);
        }
        if ((row = this.prefs.getInt("Position", 0)) > 0 && row < maxSize) {
            this.mappingTable.setValueAt("Position", row, 2);
            this.renderer.setRowColor(row, Color.ORANGE);
        }
        if ((row = this.prefs.getInt("F\u00f8dested", 0)) > 0 && row < maxSize) {
            this.mappingTable.setValueAt("F\u00f8dested", row, 2);
            this.renderer.setRowColor(row, Color.ORANGE);
        }
        if ((row = this.prefs.getInt("FT\u00c5r", 0)) > 0 && row < maxSize) {
            this.mappingTable.setValueAt("FT\u00c5r", row, 2);
            this.renderer.setRowColor(row, Color.ORANGE);
        }
    }
}

