/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import net.myerichsen.vejby.census.Census;
import net.myerichsen.vejby.ui.VejbyGedcom;

public class CensusPanel
extends JPanel {
    private static final long serialVersionUID = -6638275102973476672L;
    private static final Logger LOGGER = Logger.getLogger("global");
    private Preferences prefs = Preferences.userRoot().node("net.myerichsen.vejby.gedcom");
    private JTable censusJtable;
    private JButton btnMapningAfFelter;
    private Census censusTable;
    private JButton btnbenKipFil;
    private DefaultTableModel censusModel;

    public CensusPanel(final VejbyGedcom vejbyGedcom) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[2];
        gridBagLayout.rowHeights = new int[2];
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JScrollPane censusscrollPane = new JScrollPane();
        GridBagConstraints gbc_censusscrollPane = new GridBagConstraints();
        gbc_censusscrollPane.fill = 1;
        gbc_censusscrollPane.insets = new Insets(0, 0, 5, 0);
        gbc_censusscrollPane.gridx = 0;
        gbc_censusscrollPane.gridy = 0;
        this.add((Component)censusscrollPane, gbc_censusscrollPane);
        this.censusJtable = new JTable();
        this.censusJtable.setRowSelectionAllowed(false);
        censusscrollPane.setViewportView(this.censusJtable);
        JPanel censusButtonPanel = new JPanel();
        censusButtonPanel.setAlignmentY(1.0f);
        GridBagConstraints gbc_censusButtonPanel = new GridBagConstraints();
        gbc_censusButtonPanel.fill = 1;
        gbc_censusButtonPanel.gridx = 0;
        gbc_censusButtonPanel.gridy = 1;
        this.add((Component)censusButtonPanel, gbc_censusButtonPanel);
        censusButtonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.btnMapningAfFelter = new JButton("Mapning af felter");
        this.btnMapningAfFelter.setEnabled(false);
        this.btnMapningAfFelter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTabbedPane pane = vejbyGedcom.getTabbedPane();
                vejbyGedcom.getCensusMappingJPanel().populateMappingTable(CensusPanel.this.getCensusModel());
                pane.setEnabledAt(2, true);
                pane.setSelectedIndex(2);
            }
        });
        this.btnbenKipFil = new JButton("\u00c5ben KIP fil");
        this.btnbenKipFil.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CensusPanel.this.openKipFile(vejbyGedcom);
            }
        });
        censusButtonPanel.add(this.btnbenKipFil);
        censusButtonPanel.add(this.btnMapningAfFelter);
    }

    public DefaultTableModel getCensusModel() {
        return this.censusModel;
    }

    public Census getCensusTable() {
        return this.censusTable;
    }

    protected void openKipFile(VejbyGedcom vejbyGedcom) {
        FileNameExtensionFilter ff = new FileNameExtensionFilter("KIP fil", "csv");
        String kipFileName = this.prefs.get("KIPFILENAME", ".");
        JFileChooser kipChooser = new JFileChooser(kipFileName);
        kipChooser.setFileFilter(ff);
        int returnValue = kipChooser.showOpenDialog(null);
        if (returnValue == 0) {
            File kipFile = kipChooser.getSelectedFile();
            LOGGER.log(Level.INFO, kipFile.getPath());
            this.prefs.put("KIPFILENAME", kipFile.getPath());
            try {
                FileInputStream fis = new FileInputStream(kipFile);
                Scanner sc = new Scanner(fis);
                String[] headers = sc.nextLine().split(";");
                int index = -1;
                int i = 0;
                while (i < headers.length) {
                    if (headers[i].contains("FT\u00e5r")) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index == -1) {
                    LOGGER.log(Level.SEVERE, "FT\u00e5r ikke fundet som kolonnenavn");
                }
                String[] ftData = sc.nextLine().split(";");
                String ftYear = ftData[index].substring(3);
                LOGGER.log(Level.INFO, ftYear);
                int year = Integer.parseInt(ftYear);
                this.setCensusTable(Census.getInstance(year));
                String message = this.getCensusTable().readKipfile(kipFile);
                LOGGER.log(Level.INFO, message);
                message = this.getCensusTable().removeEmptyColumns();
                LOGGER.log(Level.INFO, message);
                sc.close();
                fis.close();
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
            }
            Object[][] censusArray = new String[this.getCensusTable().getPersons().size()][this.getCensusTable().getHeaders().size()];
            List<List<String>> lls = this.getCensusTable().getPersons();
            int i = 0;
            while (i < lls.size()) {
                List<String> list = lls.get(i);
                int j = 0;
                while (j < list.size()) {
                    LOGGER.log(Level.FINE, "i " + i + " j " + j + " " + list.get(j));
                    censusArray[i][j] = list.get(j);
                    ++j;
                }
                ++i;
            }
            List<String> cth = this.getCensusTable().getHeaders();
            Object[] headerArray = new String[cth.size()];
            int i2 = 0;
            while (i2 < cth.size()) {
                headerArray[i2] = cth.get(i2);
                ++i2;
            }
            this.setCensusModel(new DefaultTableModel(censusArray, headerArray));
            this.censusJtable.setModel(this.getCensusModel());
            this.btnMapningAfFelter.setEnabled(true);
        }
    }

    public void setCensusModel(DefaultTableModel censusModel) {
        this.censusModel = censusModel;
    }

    public void setCensusTable(Census censusTable) {
        this.censusTable = censusTable;
    }
}

