/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.ui;

import java.awt.LayoutManager;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public abstract class FsPanel
extends JPanel {
    private static final long serialVersionUID = -4008194513738386085L;
    protected static final Logger LOGGER = Logger.getLogger("global");
    protected String[][] dataArray;
    protected String[] headerArray;
    protected JTable table;
    protected Preferences prefs = Preferences.userRoot().node("net.myerichsen.vejby.gedcom");
    protected JButton saveButton;
    protected String fileNameStub;
    protected JButton eliminateButton;

    public FsPanel() {
    }

    public FsPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public FsPanel(LayoutManager layout) {
        super(layout);
    }

    public FsPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    private void clearRow(int i) {
        int j = 0;
        while (j < this.dataArray[i].length) {
            this.dataArray[i][j] = "";
            ++j;
        }
    }

    protected <T> T[] concatenate(T[] a, T[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    private String dataArrayToString(int i) {
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while (j < this.dataArray[i].length) {
            sb.append(String.valueOf(this.dataArray[i][j]) + ", ");
            ++j;
        }
        LOGGER.log(Level.FINE, "[" + i + "]: " + sb.toString());
        return sb.toString();
    }

    protected void eliminateDuplicates() {
        int deletions = 0;
        String stringI = "";
        String stringJ = "";
        int i = 0;
        while (i < this.dataArray.length) {
            if (this.dataArray[i][0] != null && !this.dataArray[i][0].equals("")) {
                stringI = this.dataArrayToString(i);
                int j = i + 1;
                while (j < this.dataArray.length) {
                    if (this.dataArray[j][0] != null && !this.dataArray[j][0].equals("") && stringI.equals(stringJ = this.dataArrayToString(j))) {
                        LOGGER.log(Level.FINE, "Fundet " + i + ": " + stringI);
                        LOGGER.log(Level.FINE, "Fundet " + i + ": " + stringJ);
                        this.clearRow(j);
                        ++deletions;
                    }
                    ++j;
                }
            }
            ++i;
        }
        String[][] dataArray2 = new String[this.dataArray.length - deletions][8];
        int i2 = 0;
        String[][] stringArray = this.dataArray;
        int n = this.dataArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            if (element[0] != null && !element[0].equals("")) {
                dataArray2[i2++] = element;
            }
            ++n2;
        }
        LOGGER.log(Level.INFO, "Data array efter sletning af " + deletions + " r\u00e6kker: " + dataArray2.length);
        this.dataArray = dataArray2;
        DefaultTableModel model = new DefaultTableModel(this.dataArray, this.headerArray);
        this.table.setModel(model);
    }

    protected String fixCodePage(String[] columns, int col) {
        String s;
        try {
            s = columns[col];
        }
        catch (Exception e1) {
            s = "";
        }
        try {
            byte[] a = s.getBytes("ISO-8859-1");
            s = new String(a, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return s;
    }

    protected abstract void openTsvFile();

    protected abstract void saveAsGedcom();
}

