/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.myerichsen.vejby.census.Census;
import net.myerichsen.vejby.census.Household;
import net.myerichsen.vejby.gedcom.Family;
import net.myerichsen.vejby.gedcom.GedcomFile;
import net.myerichsen.vejby.gedcom.Individual;
import net.myerichsen.vejby.ui.VejbyGedcom;

public class HouseholdPanel
extends JPanel {
    private static final long serialVersionUID = -4694127991314617939L;
    private Household selectedHousehold;
    private VejbyGedcom vejbyGedcom;
    private Census censusTable;
    private JTable table;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode rootTreeNode;
    private DefaultTableModel householdTableModel;
    private JButton family1Button;
    private JButton family2Button;
    private JButton family3Button;
    private JButton family4Button;
    private JButton delete2Button;
    private JButton delete3Button;
    private JButton delete4Button;
    private JButton saveButton;
    private JButton clear1Button;

    public HouseholdPanel(final VejbyGedcom vejbyGedcom) {
        this.vejbyGedcom = vejbyGedcom;
        this.setLayout(new BorderLayout(0, 0));
        this.tree = new JTree();
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HouseholdPanel.this.populateTable(HouseholdPanel.this.table);
            }
        });
        this.add((Component)new JScrollPane(this.tree), "West");
        this.table = new JTable();
        this.add((Component)new JScrollPane(this.table), "Center");
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        this.family1Button = new JButton("Opdat\u00e9r familie 1");
        this.family1Button.setEnabled(false);
        this.family1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HouseholdPanel.this.updateFamily1();
            }
        });
        buttonPanel.setLayout(new GridLayout(0, 5, 0, 0));
        buttonPanel.add(this.family1Button);
        this.family2Button = new JButton("Opdat\u00e9r familie 1 og 2");
        this.family2Button.setEnabled(false);
        this.family2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HouseholdPanel.this.updateFamily1();
                HouseholdPanel.this.updateFamily2();
            }
        });
        buttonPanel.add(this.family2Button);
        this.family3Button = new JButton("Opdat\u00e9r familie 1, 2 og 3");
        this.family3Button.setEnabled(false);
        this.family3Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HouseholdPanel.this.updateFamily1();
                HouseholdPanel.this.updateFamily2();
                HouseholdPanel.this.updateFamily3();
            }
        });
        buttonPanel.add(this.family3Button);
        this.family4Button = new JButton("Opdat\u00e9r familie 1, 2, 3 og 4\r\n");
        this.family4Button.setEnabled(false);
        this.family4Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HouseholdPanel.this.updateFamily1();
                HouseholdPanel.this.updateFamily2();
                HouseholdPanel.this.updateFamily3();
                HouseholdPanel.this.updateFamily4();
            }
        });
        buttonPanel.add(this.family4Button);
        this.clear1Button = new JButton("Ryd familie 1 herfra");
        this.clear1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HouseholdPanel.this.clearFamily1FromCursor();
            }
        });
        this.clear1Button.setEnabled(false);
        buttonPanel.add(this.clear1Button);
        this.delete2Button = new JButton("Slet familie 2, 3 og 4\r\n");
        this.delete2Button.setEnabled(false);
        this.delete2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HouseholdPanel.this.deleteFamily4();
                HouseholdPanel.this.deleteFamily3();
                HouseholdPanel.this.deleteFamily2();
            }
        });
        buttonPanel.add(this.delete2Button);
        this.delete3Button = new JButton("Slet familie 3 og 4");
        this.delete3Button.setEnabled(false);
        this.delete3Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HouseholdPanel.this.deleteFamily4();
                HouseholdPanel.this.deleteFamily3();
            }
        });
        buttonPanel.add(this.delete3Button);
        this.delete4Button = new JButton("Slet familie 4");
        this.delete4Button.setEnabled(false);
        this.delete4Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HouseholdPanel.this.deleteFamily4();
            }
        });
        buttonPanel.add(this.delete4Button);
        this.saveButton = new JButton("Gem som GEDCOM");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HouseholdPanel.this.censusTable = vejbyGedcom.getCensusJPanel().getCensusTable();
                GedcomFile gedcomFile = new GedcomFile();
                String path = gedcomFile.saveCensus(HouseholdPanel.this.censusTable);
                JOptionPane.showMessageDialog(new JFrame(), "Folket\u00e6lling for " + HouseholdPanel.this.censusTable.getYear() + " er gemt som GEDCOM fil " + path, "Vejby Gedcom", 1);
            }
        });
        buttonPanel.add(this.saveButton);
    }

    protected void clearFamily1FromCursor() {
        int i = this.table.getSelectedRow();
        while (i < this.table.getRowCount()) {
            this.table.setValueAt("", i, 5);
            ++i;
        }
    }

    private void clearFamilyRoles(int i) {
        for (Individual individual : this.selectedHousehold.getPersons()) {
            if (i == 2) {
                individual.setFamilyRole2("");
                continue;
            }
            if (i == 3) {
                individual.setFamilyRole3("");
                continue;
            }
            if (i != 4) continue;
            individual.setFamilyRole4("");
        }
    }

    protected void deleteFamily2() {
        Family family2 = this.selectedHousehold.getFamilies().get(2);
        this.selectedHousehold.getFamilies().remove(family2);
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)this.rootTreeNode.getChildAt(this.selectedHousehold.getId());
        try {
            currentNode.remove(3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        currentNode.remove(2);
        this.treeModel.reload(this.rootTreeNode);
        family2 = null;
        this.clearFamilyRoles(2);
        this.rebuildSinglesList(this.householdTableModel.getDataVector(), this.selectedHousehold.getFamilies().get(0));
    }

    protected void deleteFamily3() {
        Family family3 = this.selectedHousehold.getFamilies().get(3);
        this.selectedHousehold.getFamilies().remove(family3);
        this.rootTreeNode.remove(3);
        this.treeModel.reload(this.rootTreeNode);
        family3 = null;
        this.clearFamilyRoles(3);
        this.rebuildSinglesList(this.householdTableModel.getDataVector(), this.selectedHousehold.getFamilies().get(0));
    }

    protected void deleteFamily4() {
        Family family4 = this.selectedHousehold.getFamilies().get(4);
        this.selectedHousehold.getFamilies().remove(family4);
        this.rootTreeNode.remove(4);
        this.treeModel.reload(this.rootTreeNode);
        family4 = null;
        this.clearFamilyRoles(4);
        this.rebuildSinglesList(this.householdTableModel.getDataVector(), this.selectedHousehold.getFamilies().get(0));
    }

    private void populateFamilyTable(int householdId, int familyId) {
        Family family = this.censusTable.getFamily(householdId, familyId);
        Object[] columnNames = new String[]{"L\u00f8benr", "Navn", "Civilstand", "Erhverv", "Rolle"};
        Object[][] data = family.getMembers();
        DefaultTableModel familyTableModel = new DefaultTableModel(data, columnNames);
        this.table.setModel(familyTableModel);
    }

    private void populateHouseholdTable(int id) {
        this.selectedHousehold = this.censusTable.getHouseholds().get(id);
        Object[] columnNames = new String[]{"L\u00f8benr", "Navn", "Civilstand", "Erhverv", "Stilling", "Familie 1", "Familie 2", "Familie 3", "Familie 4"};
        int size = this.selectedHousehold.getPersonCount();
        Object[][] data = new String[size][columnNames.length];
        int i = 0;
        while (i < size) {
            Individual person = this.selectedHousehold.getPerson(i);
            data[i][0] = String.valueOf(person.getId());
            data[i][1] = person.getName();
            data[i][2] = person.getMaritalStatus();
            data[i][3] = person.getTrade();
            data[i][4] = person.getPosition();
            data[i][5] = person.getFamilyRole1();
            data[i][6] = person.getFamilyRole2();
            data[i][7] = person.getFamilyRole3();
            data[i][8] = person.getFamilyRole4();
            ++i;
        }
        this.householdTableModel = new DefaultTableModel(data, columnNames);
        this.table.setModel(this.householdTableModel);
        JComboBox<String> familyRoleComboBox = new JComboBox<String>();
        familyRoleComboBox.addItem("");
        familyRoleComboBox.addItem("Fader");
        familyRoleComboBox.addItem("Moder");
        familyRoleComboBox.addItem("Barn");
        this.table.getColumnModel().getColumn(5).setCellEditor(new DefaultCellEditor(familyRoleComboBox));
        this.table.getColumnModel().getColumn(6).setCellEditor(new DefaultCellEditor(familyRoleComboBox));
        this.table.getColumnModel().getColumn(7).setCellEditor(new DefaultCellEditor(familyRoleComboBox));
        this.table.getColumnModel().getColumn(8).setCellEditor(new DefaultCellEditor(familyRoleComboBox));
    }

    private void populateTable(JTable table) {
        DefaultMutableTreeNode lastSelectedPathComponent = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        Object userObject = lastSelectedPathComponent.getUserObject();
        if (userObject instanceof Household) {
            this.populateHouseholdTable(((Household)userObject).getId());
        } else if (userObject instanceof Family) {
            this.populateFamilyTable(((Family)userObject).getHouseholdId(), ((Family)userObject).getFamilyId());
        }
        this.family1Button.setEnabled(true);
        this.family2Button.setEnabled(true);
        this.family3Button.setEnabled(true);
        this.family4Button.setEnabled(true);
        this.clear1Button.setEnabled(true);
    }

    public void populateTree() {
        this.tree.setRootVisible(false);
        this.rootTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        if (this.rootTreeNode != null) {
            this.rootTreeNode.removeAllChildren();
        }
        this.censusTable = this.vejbyGedcom.getCensusJPanel().getCensusTable();
        for (Household household : this.censusTable.getHouseholds()) {
            DefaultMutableTreeNode householdNode = new DefaultMutableTreeNode(household);
            this.rootTreeNode.add(householdNode);
            for (Family family : household.getFamilies()) {
                DefaultMutableTreeNode familyNode = new DefaultMutableTreeNode(family);
                householdNode.add(familyNode);
            }
        }
        this.treeModel = (DefaultTreeModel)this.tree.getModel();
        this.treeModel.reload(this.rootTreeNode);
    }

    public void rebuildSinglesList(Vector<Vector<String>> dataVector, Family family0) {
        int i = 0;
        while (i < dataVector.size()) {
            Individual individual = this.selectedHousehold.getPerson(i);
            if (individual.getFamilyRole1().equals("") && individual.getFamilyRole2().equals("") && individual.getFamilyRole3().equals("")) {
                family0.getSingles().add(individual);
            }
            ++i;
        }
    }

    private void updateFamily1() {
        TreePath selectedNode = this.tree.getSelectionPath();
        this.selectedHousehold.getFamilies().clear();
        Family family0 = new Family(this.selectedHousehold.getId(), 0);
        Family family1 = new Family(this.selectedHousehold.getId(), 1);
        Vector<Vector> dataVector = this.householdTableModel.getDataVector();
        int i = 0;
        while (i < dataVector.size()) {
            Vector tableRowVector = dataVector.get(i);
            Individual individual = this.selectedHousehold.getPerson(i);
            String newRole = (String)tableRowVector.get(5);
            if (newRole.startsWith("F")) {
                family1.setFather(individual);
            } else if (newRole.startsWith("M")) {
                family1.setMother(individual);
            } else if (newRole.startsWith("B")) {
                family1.getChildren().add(individual);
            } else {
                family0.getSingles().add(individual);
            }
            individual.setFamilyRole1(newRole);
            ++i;
        }
        this.selectedHousehold.getFamilies().add(family0);
        this.selectedHousehold.getFamilies().add(family1);
        this.treeModel.reload(this.rootTreeNode);
        this.tree.setSelectionPath(selectedNode);
        this.table.setModel(this.householdTableModel);
    }

    protected void updateFamily2() {
        TreePath selectedNode = this.tree.getSelectionPath();
        Family oldFamily0 = this.selectedHousehold.getFamilies().get(0);
        Family family2 = new Family(this.selectedHousehold.getId(), 2);
        Vector<Vector<String>> dataVector = this.householdTableModel.getDataVector();
        int i = 0;
        while (i < dataVector.size()) {
            Vector tableRowVector = dataVector.get(i);
            Individual individual = this.selectedHousehold.getPerson(i);
            String newRole = (String)tableRowVector.get(6);
            if (newRole.startsWith("F")) {
                family2.setFather(individual);
            } else if (newRole.startsWith("M")) {
                family2.setMother(individual);
            } else if (newRole.startsWith("B")) {
                family2.getChildren().add(individual);
            }
            individual.setFamilyRole2(newRole);
            ++i;
        }
        this.selectedHousehold.getFamilies().add(family2);
        Family family0 = new Family(this.selectedHousehold.getId(), 0);
        this.rebuildSinglesList(dataVector, family0);
        this.selectedHousehold.getFamilies().remove(oldFamily0);
        this.selectedHousehold.getFamilies().add(0, family0);
        DefaultMutableTreeNode householdNode = (DefaultMutableTreeNode)this.rootTreeNode.getChildAt(this.selectedHousehold.getId());
        DefaultMutableTreeNode family2Node = new DefaultMutableTreeNode(family2);
        householdNode.add(family2Node);
        this.treeModel.reload(this.rootTreeNode);
        this.tree.setSelectionPath(selectedNode);
        this.delete2Button.setEnabled(true);
    }

    protected void updateFamily3() {
        TreePath selectedNode = this.tree.getSelectionPath();
        Family oldFamily0 = this.selectedHousehold.getFamilies().get(0);
        Family family3 = new Family(this.selectedHousehold.getId(), 3);
        Vector<Vector<String>> dataVector = this.householdTableModel.getDataVector();
        int i = 0;
        while (i < dataVector.size()) {
            Vector tableRowVector = dataVector.get(i);
            Individual individual = this.selectedHousehold.getPerson(i);
            String newRole = (String)tableRowVector.get(7);
            if (newRole.startsWith("F")) {
                family3.setFather(individual);
            } else if (newRole.startsWith("M")) {
                family3.setMother(individual);
            } else if (newRole.startsWith("B")) {
                family3.getChildren().add(individual);
            }
            individual.setFamilyRole3(newRole);
            ++i;
        }
        this.selectedHousehold.getFamilies().add(family3);
        Family family0 = new Family(this.selectedHousehold.getId(), 0);
        this.rebuildSinglesList(dataVector, family0);
        this.selectedHousehold.getFamilies().remove(oldFamily0);
        this.selectedHousehold.getFamilies().add(0, family0);
        DefaultMutableTreeNode householdNode = (DefaultMutableTreeNode)this.rootTreeNode.getChildAt(this.selectedHousehold.getId());
        DefaultMutableTreeNode family3Node = new DefaultMutableTreeNode(family3);
        householdNode.add(family3Node);
        this.treeModel.reload(this.rootTreeNode);
        this.tree.setSelectionPath(selectedNode);
        this.delete3Button.setEnabled(true);
    }

    protected void updateFamily4() {
        TreePath selectedNode = this.tree.getSelectionPath();
        Family oldFamily0 = this.selectedHousehold.getFamilies().get(0);
        Family family4 = new Family(this.selectedHousehold.getId(), 4);
        Vector<Vector<String>> dataVector = this.householdTableModel.getDataVector();
        int i = 0;
        while (i < dataVector.size()) {
            Vector tableRowVector = dataVector.get(i);
            Individual individual = this.selectedHousehold.getPerson(i);
            String newRole = (String)tableRowVector.get(8);
            if (newRole.startsWith("F")) {
                family4.setFather(individual);
            } else if (newRole.startsWith("M")) {
                family4.setMother(individual);
            } else if (newRole.startsWith("B")) {
                family4.getChildren().add(individual);
            }
            individual.setFamilyRole4(newRole);
            ++i;
        }
        this.selectedHousehold.getFamilies().add(family4);
        Family family0 = new Family(this.selectedHousehold.getId(), 0);
        this.rebuildSinglesList(dataVector, family0);
        this.selectedHousehold.getFamilies().remove(oldFamily0);
        this.selectedHousehold.getFamilies().add(0, family0);
        DefaultMutableTreeNode householdNode = (DefaultMutableTreeNode)this.rootTreeNode.getChildAt(this.selectedHousehold.getId());
        DefaultMutableTreeNode family4Node = new DefaultMutableTreeNode(family4);
        householdNode.add(family4Node);
        this.treeModel.reload(this.rootTreeNode);
        this.tree.setSelectionPath(selectedNode);
        this.delete4Button.setEnabled(true);
    }
}

