/*
 * Decompiled with CFR 0.152.
 */
package net.myerichsen.vejby.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import net.myerichsen.vejby.gedcom.Family;
import net.myerichsen.vejby.gedcom.GedcomFile;
import net.myerichsen.vejby.gedcom.Individual;
import net.myerichsen.vejby.ui.FsPanel;

public class MarriagePanel
extends FsPanel {
    private static final long serialVersionUID = -4314220214428910383L;

    public MarriagePanel() {
        this.dataArray = new String[0][6];
        this.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "Center");
        this.table = new JTable();
        scrollPane.setViewportView(this.table);
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        JButton openButton = new JButton("\u00c5ben Family Search eksport fil");
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarriagePanel.this.openTsvFile();
            }
        });
        buttonPanel.add(openButton);
        this.eliminateButton = new JButton("Fjern dubletter");
        this.eliminateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarriagePanel.this.eliminateDuplicates();
            }
        });
        this.eliminateButton.setEnabled(false);
        buttonPanel.add(this.eliminateButton);
        this.saveButton = new JButton("Gem som Gedcom");
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarriagePanel.this.saveAsGedcom();
            }
        });
        buttonPanel.add(this.saveButton);
    }

    @Override
    protected void openTsvFile() {
        this.headerArray = new String[8];
        FileNameExtensionFilter ff = new FileNameExtensionFilter("FS eksport fil (TSV)", "tsv");
        String fsFileName = this.prefs.get("FSFILENAME", ".");
        String[][] marriageArray = new String[100][6];
        JFileChooser fsChooser = new JFileChooser(fsFileName);
        fsChooser.setFileFilter(ff);
        fsChooser.setMultiSelectionEnabled(true);
        int returnValue = fsChooser.showOpenDialog(null);
        if (returnValue == 0) {
            File[] fsFiles = fsChooser.getSelectedFiles();
            this.fileNameStub = fsFiles[0].getName().replaceFirst("[.][^.]+$", "");
            LOGGER.log(Level.INFO, fsFiles[0].getPath());
            this.prefs.put("KIPFILENAME", fsFiles[0].getPath());
            int fileNo = 0;
            while (fileNo < fsFiles.length) {
                try {
                    marriageArray = new String[100][6];
                    FileInputStream fis = new FileInputStream(fsFiles[fileNo]);
                    Scanner sc = new Scanner(fis);
                    String[] columns = sc.nextLine().split("\t");
                    if (fileNo == 0) {
                        this.headerArray[0] = columns[8];
                        this.headerArray[1] = columns[9];
                        this.headerArray[2] = columns[10];
                        this.headerArray[3] = columns[16];
                        this.headerArray[4] = columns[17];
                        this.headerArray[5] = columns[24];
                    }
                    sc.nextLine();
                    int i = 0;
                    while (sc.hasNext()) {
                        columns = sc.nextLine().split("\t");
                        marriageArray[i][0] = this.fixCodePage(columns, 8);
                        marriageArray[i][1] = columns[9];
                        marriageArray[i][2] = columns[10];
                        marriageArray[i][3] = columns[16];
                        marriageArray[i][4] = columns[17];
                        marriageArray[i][5] = this.fixCodePage(columns, 24);
                        ++i;
                    }
                    sc.close();
                    fis.close();
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                }
                this.dataArray = (String[][])this.concatenate((T[])this.dataArray, (T[])marriageArray);
                LOGGER.log(Level.FINE, "Data array length after concatenation: " + this.dataArray.length);
                ++fileNo;
            }
            LOGGER.log(Level.INFO, "Data array length after concatenations: " + this.dataArray.length);
        }
        DefaultTableModel model = new DefaultTableModel(this.dataArray, this.headerArray);
        this.table.setModel(model);
        this.saveButton.setEnabled(true);
        this.eliminateButton.setEnabled(true);
    }

    @Override
    protected void saveAsGedcom() {
        GedcomFile gedcomFile = new GedcomFile();
        Individual groom = null;
        Individual bride = null;
        int individualId = 1;
        String[] line = new String[5];
        int i = 0;
        while (i < this.dataArray.length) {
            line = this.dataArray[i];
            if (line[0] != null) {
                LOGGER.log(Level.INFO, String.valueOf(i) + ", " + line[0] + ", " + line[1] + ", " + line[2] + ", " + line[3] + ", " + line[4] + ", " + line[5]);
                Family family = new Family(0, i);
                if (line[1].equals("male")) {
                    groom = new Individual(individualId++);
                    groom.setName(line[0]);
                    if (!line[2].equals("")) {
                        groom.setBirthDate(line[2]);
                    }
                    bride = new Individual(individualId++);
                    bride.setName(line[5]);
                } else {
                    bride = new Individual(individualId++);
                    bride.setName(line[0]);
                    if (!line[2].equals("")) {
                        bride.setBirthDate(line[2]);
                    }
                    groom = new Individual(individualId++);
                    groom.setName(line[5]);
                }
                groom.setSex("M");
                bride.setSex("F");
                family.setFather(groom);
                family.setMother(bride);
                family.setMarriageDate(line[3]);
                family.setMarriagePlace(line[4]);
                gedcomFile.addFamily(family);
            }
            ++i;
        }
        String path = gedcomFile.saveFsExtract(this.fileNameStub);
        if (!path.equals("")) {
            JOptionPane.showMessageDialog(new JFrame(), "Vielser er gemt som GEDCOM fil " + path, "Vejby Gedcom", 1);
        }
    }
}

